//---------------------------------------------------------------------------
//
//  LabJack U12 Legacy driver example using dynamic linking.  Tested on
//  Dev-C++ 4.9.9.2, but should work with any Windows C compiler.
//
//  support@labjack.com
//  8/2005
//----------------------------------------------------------------------
//

#include <stdio.h>
#include <wtypes.h>
#include <iostream>

//First define structures that have the same format as the desired function prototype.
using namespace std;
typedef long (CALLBACK *tEAnalogIn)(long*,long,long,long,long*,float*);
typedef long (CALLBACK *tEAnalogOut)(long*,long,float,float);
typedef long (CALLBACK *tECount)(long*,long,double*);
typedef long (CALLBACK *tEDigitalIn)(long*,long,long,long,long*);
typedef long (CALLBACK *tEDigitalOut)(long*,long,long,long,long);
typedef long (CALLBACK *tAISample)(long*,long,long*,long,long,long,long*,long*,long,long*,float*);
typedef long (CALLBACK *tAIBurst)(long*,long,long*,long,long,long,long*,long*,long*,long,long,long,long,long,float**,long*,long*,long);
typedef long (CALLBACK *tAIStreamStart)(long*,long,long*,long,long,long,long*,long*,long*,long,long,long);
typedef long (CALLBACK *tAIStreamRead)(long,long,long,float**,long*,long*,long*,long*);
typedef long (CALLBACK *tAOUpdate)(long*,long,long,long,long*,long*,long,long,unsigned long*,float,float);
typedef long (CALLBACK *tAIStreamClear)(long);
typedef long (CALLBACK *tAsynchConfig)(long*,long,long,long,long,long,long,long,long,long,long,long);
typedef long (CALLBACK *tAsynch)(long*,long,long,long,long,long,long,long,long,long*);
typedef long (CALLBACK *tBitstoVolts)(long,long,long,float*);
typedef long (CALLBACK *tVoltstoBits)(long,long,float,long*);
typedef long (CALLBACK *tCounter)(long*,long,long*,long*,long,long,unsigned long*);
typedef long (CALLBACK *tDigitalIO)(long*,long,long*,long,long*,long*,long,long*);
typedef float (CALLBACK *tGetDriverVersion)(void);
typedef void (CALLBACK *tGetErrorString)(long errorcode, char *errorString);
typedef float (CALLBACK *tGetFirmwareVersion)(long *idnum);
typedef long (CALLBACK *tGetWinVersion)(unsigned long*,unsigned long*,unsigned long*,unsigned long*,unsigned long*,unsigned long*);
typedef long (CALLBACK *tListAll)(long*,long*,long*,long*,long**,long*,long*,long*);
typedef long (CALLBACK *tLocalID)(long*,long);
typedef long (CALLBACK *tNoThread)(long*,long);
typedef long (CALLBACK *tPulseOut)(long*,long,long,long,long,long,long,long,long);
typedef long (CALLBACK *tPulseOutStart)(long*,long,long,long,long,long,long,long,long);
typedef long (CALLBACK *tPulseOutCalc)(float*,long*,long*);
typedef long (CALLBACK *tPulseOutFinish)(long*,long,long);
typedef long (CALLBACK *tPulseOutCalc)(float*,long*,long*);
typedef long (CALLBACK *tReEnum)(long*);
typedef long (CALLBACK *tReset)(long*);

 
main()
{
    //Define a variable to hold a handle to the loaded DLL.
    HINSTANCE hDLLInstance;
     
    //Define variables for functions we will use.
    tEAnalogIn m_pEAnalogIn;
    tEDigitalIn m_pEDigitalIn;
    tAISample m_pAISample;
    tAOUpdate m_pAOUpdate;
     
    //Now try and load the DLL.
    if (hDLLInstance = LoadLibrary("ljackuw.dll"))
    {  
        //If successfully loaded, get the address of the desired functions.
        m_pEAnalogIn = (tEAnalogIn)::GetProcAddress(hDLLInstance,"EAnalogIn");
        m_pEDigitalIn = (tEDigitalIn)::GetProcAddress(hDLLInstance,"EDigitalIn");
        m_pAISample = (tAISample)::GetProcAddress(hDLLInstance,"AISample");
        m_pAOUpdate = (tAOUpdate)::GetProcAddress(hDLLInstance,"AOUpdate");
    }
    else
    {
        printf("\nFailed to load DLL\n");
        getchar();
        return 0;
    }
    
    // m_pEAnalogIn now holds a pointer to the EAnalogIn function.  The compiler
    // automatically recognizes m_pEAnalogIn as a pointer to a function and
    // calls the function with the parameters given.  If we created another
    // variable of type tEAnalogIn and simply put "pNewVar = m_pEAnalogIn",
    // then the compiler might not know to call the function.
     
    long errorcode;
    long idnum=-1;
    long stateIO=0;
    //long numCh=4;
    long channels[4];
    long gains[4]={0,0,0,0};
    long ov=0;
    long state=0;
    //long i=0;
    float voltage=0;
    float voltages[4]={0,0,0,0}; //must initialize voltages array to zeros
    long trisD=0,trisIO=0,stateD=0;
    unsigned long count=0;
    float AO0,AO1;
 
    //Read AIN3   
    errorcode = m_pEAnalogIn(&idnum,0,3,0,&ov,&voltage);
    printf("\nEAnalogIn error = %d\n",errorcode);
    printf("Local ID = %d\n",idnum);
    printf("AI3 = %f\n",voltage);
    
    //Read D2
    errorcode = m_pEDigitalIn(&idnum,0,2,1,&state);
    printf("\nEDigitalIn error = %d\n",errorcode);
    printf("D2 = %d\n",state);
    
    //Read all 8 analog inputs with 2 calls to AISample
    channels[0]=0;
	channels[1]=1;
	channels[2]=2;
	channels[3]=3;
    errorcode = m_pAISample(&idnum,0,&stateIO,0,1,4,channels,gains,0,&ov,voltages);
	printf("\nAISample error = %d\n",errorcode);
	printf("AI0 = %f\n",voltages[0]);
	printf("AI1 = %f\n",voltages[1]);
	printf("AI2 = %f\n",voltages[2]);
	printf("AI3 = %f\n",voltages[3]);
    channels[0]=4;
	channels[1]=5;
	channels[2]=6;
	channels[3]=7;
	voltages[0]=0;  //must initialize voltages array to zeros
	voltages[1]=0;
	voltages[2]=0;
	voltages[3]=0;
    errorcode = m_pAISample(&idnum,0,&stateIO,0,1,4,channels,gains,0,&ov,voltages);
	printf("\nAISample error = %d\n",errorcode);
	printf("AI4 = %f\n",voltages[0]);
	printf("AI5 = %f\n",voltages[1]);
	printf("AI6 = %f\n",voltages[2]);
	printf("AI7 = %f\n",voltages[3]);
    
    //Write the analog outputs and write and read some digital I/O
    //First, we configure IO0 and IO1 as output-high, IO2 as
    //input, and IO3 as output-low.
    trisIO=0;
    trisIO=trisIO|1;  //Set IO0 to output.
    trisIO=trisIO|2;  //Set IO1 to output.
    trisIO=trisIO|8;  //Set IO3 to output.
    stateIO=0;
    stateIO=stateIO|1;  //Set IO0 to output-high.
    stateIO=stateIO|2;  //Set IO1 to output-high.
    AO0 = 2.0;  //Set AO0 to 2 volts.
    AO1 = 4.0;  //Set AO1 to 4 volts.
    errorcode = m_pAOUpdate(&idnum,0,trisD,trisIO,&stateD,&stateIO,1,0,&count,AO0,AO1);
    printf("\nAOUpdate error = %d\n",errorcode);
    printf("IO2 state = %d\n",((stateIO & 4)>>2));
    
    printf("\nPress Enter\n");
    getchar();
    
    return 0; 

}

